# count 练习

Joe 建立了一个名为items的表

```
mysql> select * from items;
+----+-----------+
| id | item      |
+----+-----------+
|  1 |         2 |
|  2 |      NULL |
|  3 |         9 |
|  4 | 534214123 |
+----+-----------+
```

当他执行

```sql
select count(*), count(item) 
from items;
```

会得到什么结果？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|        4 |           3 |
+----------+-------------+
1 row in set (0.00 sec)
```

## 选项

### A

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|        4 |        NULL |
+----------+-------------+
1 row in set (0.00 sec)
```

### B

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|        3 |           3 |
+----------+-------------+
1 row in set (0.00 sec)
```

### C

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|        4 |           4 |
+----------+-------------+
1 row in set (0.00 sec)
```

### D

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|     NULL |        NULL |
+----------+-------------+
1 row in set (0.00 sec)
```

### E

```
+----------+-------------+
| count(*) | count(item) |
+----------+-------------+
|        4 |           0 |
+----------+-------------+
1 row in set (0.00 sec)
```